# Encryption in Modern Networks

## The Role of Encryption

- Enables privacy and security for enterprise communications and transactions.
- Used by mobile, cloud, and web applications through keys and certificates.
- Also used by threat actors to evade detection and hide malicious activity.
- Makes traditional inspection and detection methods less effective.
- Organizations must distinguish between legitimate encrypted traffic and threats.

## Common Encryption Protocols

- **SSL (Secure Sockets Layer):** Developed in the 1990s by Netscape for secure web transactions.
- **TLS (Transport Layer Security):** Standardized by IETF, successor to SSL.
- Commonly implemented over HTTP (as HTTPS), SMTP, and other protocols.

---

# Security Challenges with Encrypted Traffic

## Threat Actor Advantages

- Encrypted traffic can bypass firewalls and IPS because payload is hidden.
- Malware delivery, command and control, and data exfiltration often use encryption.
- Decrypting all traffic at the network edge is impractical due to resource and PKI management challenges.

## The Solution: Cisco Encrypted Traffic Analytics (ETA)

- Detects threats in encrypted traffic **without decryption**.
- Uses enhanced NetFlow to extract key metadata fields for analysis.

---

# Cisco Encrypted Traffic Analytics (ETA) Features

## Key Data Elements Extracted

- **Initial Data Packet (IDP):** Contains unencrypted metadata like HTTP URLs, DNS info, cipher suites, and protocol versions.
- **Sequence of Packet Lengths and Times (SPLT):** Records packet sizes and timing, revealing traffic patterns.
- **Byte Distribution:** Histogram of byte values in the payload.
- **Threat Intelligence:** Integrates GTA (Global Threat Alerts) machine learning and analysis for enhanced detection.

## Enhanced NetFlow

- Supported on latest Cisco networking equipment (via special ASICs).
- Exports additional ETA data to Flow Collectors with minimal performance impact.

---

# ETA and Threat Detection

## How ETA Detects Malware

- Machine learning distinguishes between legitimate and malicious encrypted traffic using metadata patterns (SPLT, IDP, etc.).
- Differences in communication patterns are flagged by detection algorithms.
- GTA integration allows Secure Network Analytics to correlate local traffic with global threat behaviors.

## Configuration Requirements

- Networking equipment must support and be configured for enhanced NetFlow.
- GTA integration must be enabled on Manager and relevant Flow Collectors for ETA-based malware detection.

---

# Use Cases for Cisco ETA

## 1. Malware Detection (ETA-MD)

- Detects ransomware and threats hidden in encrypted traffic.
- Uses both IDP and SPLT data.
- Requires connection to GTA for global threat intelligence.
- Only effective for outbound encrypted traffic.

## 2. Cryptographic Compliance Audit (ETA-CA)

- Verifies protocol versions (e.g., TLS 1.1, TLS 1.3) and cipher suites in use.
- Uses IDP data to assess compliance with industry standards.
- Ensures weak ciphers are not being used.

## Requirements

- Both use cases need the IDP.
- ETA-MD additionally needs SPLT and external traffic.

---

# Integration and Reporting

## GTA Integration

- Correlates enhanced NetFlow data with global threat intelligence.
- Provides behavioral profiling and maintains a global risk map.
- Machine learning identifies patterns in encrypted traffic.

## Alerting and Visibility

- ETA detections are tagged in Secure Network Analytics Manager.
    - Blue ETA tag: Detection based on encrypted telemetry.
    - Orange ETA tag: Detection used ETA telemetry but traffic wasn’t encrypted.
- Crypto compliance reports show flow tables with encryption details.

## Monitoring

- Use the ETA Cryptographic Audit app to monitor encryption algorithms and host groups for compliance.
- Segment the network and ensure strong encryption in all segments.

---

**Summary:**  
Encryption secures business communications but also helps cyber threats evade detection. Cisco Encrypted Traffic Analytics (ETA) provides deep insight into encrypted traffic without decryption by extracting and analyzing metadata. Integrated with Cisco Global Threat Alerts, ETA enables both malware detection and cryptographic compliance auditing, allowing organizations to balance security, privacy, and regulatory needs.